/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.system.RestartData;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RestartManager
implements Persistable {
    private static final String TRACE_MASKT = "XFRMRSTT";
    private static final String TRACE_MASKF = "XFRMRSTF";
    private static final String TRACE_MASKD = "XFRMRSTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RestartMgr");
    public static final short RM_PERSISTENCE_LOAD_ERROR = 1120;
    private static final String persistItem = ".theRestartManager";
    private static String persistId = null;
    private static RestartManager theRM = new RestartManager();
    private List restartData = new ArrayList();
    private UUID uuid = UUIDFactory.generate(4);
    private Tasklet tasklet = null;
    private String userId = "";
    private PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
    private Object persistenceGate = new Object();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$system$StartupHook;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestartManager() {
        Trace.trace(TRACE_MASKT, "-> RestartManager()");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (theRM != null) {
                throw new IllegalStateException("Singleton RestartManager already instantiated.");
            }
            theRM = this;
            this.loadPersistentData();
        }
        Trace.trace(TRACE_MASKT, "<- RestartManager()");
    }

    private RestartManager(PersistentData data) {
        RestartManagerPersistentData oldData = (RestartManagerPersistentData)data;
        this.restartData = oldData.restartData;
    }

    public static synchronized RestartManager getRestartManager() {
        if (null == theRM) {
            theRM = new RestartManager();
        }
        return theRM;
    }

    public static synchronized RestartManager getRestartManager(Tasklet tasklet) {
        if (null == theRM) {
            theRM = new RestartManager();
        }
        RestartManager.theRM.tasklet = tasklet;
        return theRM;
    }

    public boolean addPreInit(String restartClass) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> RestartManager.addPreInit() - Restart request received for " + restartClass);
        this.add(restartClass, false);
        Trace.trace(TRACE_MASKT, "<- RestartManager.addPreInit() - " + this.restartData.size() + " restart requests are queued");
        return true;
    }

    public boolean addPostInit(String restartClass) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> RestartManager.addPostInit() - Restart request received for " + restartClass);
        this.add(restartClass, true);
        Trace.trace(TRACE_MASKT, "<- RestartManager.addPostInit() - " + this.restartData.size() + " restart requests are queued");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(String restartClass, boolean wantPostInit) throws IllegalArgumentException {
        Class<?> theirClass;
        Trace.trace(TRACE_MASKT, "-> RestartManager.add() - Restart request received for " + restartClass + " wantPostInit is " + wantPostInit);
        try {
            theirClass = Class.forName(restartClass);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "-> RestartManager.add() - Class.forName exception: " + e.getMessage());
            throw new IllegalArgumentException("Invalid class for requested function - forName failed");
        }
        if (!(class$com$ibm$hwmca$fw$system$StartupHook == null ? (class$com$ibm$hwmca$fw$system$StartupHook = RestartManager.class$("com.ibm.hwmca.fw.system.StartupHook")) : class$com$ibm$hwmca$fw$system$StartupHook).isAssignableFrom(theirClass)) {
            throw new IllegalArgumentException("Invalid class for requested function - does not extend StartupHook");
        }
        List list = this.restartData;
        synchronized (list) {
            RestartData info = new RestartData(restartClass, this.uuid, true);
            if (this.restartData.contains(info)) {
                throw new IllegalArgumentException("Class previously added");
            }
            this.restartData.add(info);
            this.persist();
        }
        Trace.trace(TRACE_MASKT, "<- RestartManager.add() - " + this.restartData.size() + " restart requests are queued");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String restartClass) {
        Trace.trace(TRACE_MASKT, "-> RestartManager.remove() - Restart request deletion for " + restartClass);
        Object removed = null;
        List list = this.restartData;
        synchronized (list) {
            Iterator iterator = this.restartData.iterator();
            while (iterator.hasNext()) {
                RestartData restartItem = (RestartData)iterator.next();
                Trace.trace(TRACE_MASKF, "   RestartManager.run() - Restarting " + restartItem);
                String className = restartItem.getClassName();
                if (!className.equals(restartClass)) continue;
                int idx = this.restartData.indexOf(restartItem);
                removed = this.restartData.remove(idx);
                this.persist();
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestartManager.delete() - " + this.restartData.size() + " restart requests are queued");
        return removed;
    }

    String getPreInitStartupHook() {
        Trace.trace(TRACE_MASKT, "-> RestartManager.getPreInitStartupHook()");
        String className = this.getStartupHook(false);
        Trace.trace(TRACE_MASKT, "<- RestartManager.getPreInitStartupHook() - Class is " + className);
        return className;
    }

    String getPostInitStartupHook() {
        Trace.trace(TRACE_MASKT, "-> RestartManager.getPostInitStartupHook()");
        String className = this.getStartupHook(true);
        Trace.trace(TRACE_MASKT, "<- RestartManager.getPostInitStartupHook() - Class is " + className);
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStartupHook(boolean wantPostInit) {
        Trace.trace(TRACE_MASKT, "-> RestartManager.getStartupHook()");
        String restartClass = null;
        List list = this.restartData;
        synchronized (list) {
            Iterator iterator = this.restartData.iterator();
            while (iterator.hasNext()) {
                RestartData restartItem = (RestartData)iterator.next();
                UUID itemUUID = restartItem.getSessionUUID();
                String className = restartItem.getClassName();
                boolean isPostInit = restartItem.isPostInit();
                Trace.trace(TRACE_MASKF, "   RestartManager.run() - Checking " + restartItem);
                if (itemUUID == this.uuid || wantPostInit != isPostInit) continue;
                Trace.trace(TRACE_MASKF, "   RestartManager.getStartupHook() - Found " + restartItem);
                restartClass = className;
                int idx = this.restartData.indexOf(restartItem);
                this.restartData.remove(idx);
                this.persist();
                break;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestartManager.getStartupHook() - Restart class is " + restartClass);
        return restartClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPersistentData() {
        Trace.trace(TRACE_MASKT, "-> RestartManager.loadPersistentData()");
        Object object = theRM;
        synchronized (object) {
            if (null == persistId) {
                persistId = this.getClass().getName() + persistItem;
                Trace.trace(TRACE_MASKF, "   RestartManager.loadPersistentData() persistId = " + persistId);
            }
        }
        object = this.persistenceGate;
        synchronized (object) {
            try {
                RestartManagerPersistentData oldInfo = (RestartManagerPersistentData)this.persMgr.read(persistId);
                if (oldInfo != null) {
                    this.restartData = oldInfo.restartData;
                }
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "-> RestartManager.loadPersistentData() persistId = " + persistId);
                new FrameworkLog(classLogInfo, 1120, pe).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestartManager.loadPersistentData()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        Trace.trace(TRACE_MASKD, "-> RestartManager.persist()");
        Object object = theRM;
        synchronized (object) {
            if (persistId == null) {
                persistId = this.getClass().getName() + persistItem;
                Trace.trace(TRACE_MASKF, "   RestartManager.persist() persistId = " + persistId);
            }
        }
        object = this.persistenceGate;
        synchronized (object) {
            try {
                RestartManagerPersistentData saveInfo = new RestartManagerPersistentData();
                saveInfo.restartData = RestartManager.theRM.restartData;
                this.persMgr.write(persistId, saveInfo);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "   RestartManager.persist() - Exception caught in BaseTower.persist() = " + e);
            }
        }
        Trace.trace(TRACE_MASKD, "<- RestartManager.persist()");
    }

    public boolean isUpgradeData() {
        return false;
    }

    public PersistentData getPersistentData() {
        RestartManagerPersistentData saveInfo = new RestartManagerPersistentData();
        saveInfo.restartData = RestartManager.theRM.restartData;
        return saveInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RestartManagerPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        List restartData = null;

        private RestartManagerPersistentData() {
        }
    }
}

